#!/usr/bin/env node
"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var yargs_1 = __importDefault(require("yargs"));
var path_1 = require("path");
var _1 = require(".");
var installations_1 = require("./installations");
var check_1 = require("./check");
var console_1 = require("./console");
var rc_1 = require("./rc");
var updateFlags = ['update', 'upgrade', 'up'];
var publishFlags = __spreadArrays([
    'scripts',
    'sig',
    'dev-mod',
    'changed',
    'files'
], updateFlags);
var cliCommand = _1.values.myNameIs;
var getVersionMessage = function () {
    var pkg = require(__dirname + '/../package.json');
    return pkg.version;
};
console_1.makeConsoleColored();
var rcArgs = rc_1.readRcConfig();
if (process.argv.includes('--quiet') || rcArgs.quiet) {
    console_1.disabledConsoleOutput();
}
var getPublishOptions = function (argv, override) {
    if (override === void 0) { override = {}; }
    var folder = argv._[1];
    return __assign({ workingDir: path_1.join(process.cwd(), folder || ''), push: argv.push, replace: argv.replace, signature: argv.sig, changed: argv.changed, files: argv.files, private: argv.private, scripts: argv.scripts, update: argv.update || argv.upgrade, workspaceResolve: argv.workspaceResolve, devMod: argv.devMod }, override);
};
/* tslint:disable-next-line */
yargs_1.default
    .usage(cliCommand + ' [command] [options] [package1 [package2...]]')
    .coerce('store-folder', function (folder) {
    if (!_1.yalcGlobal.yalcStoreMainDir) {
        _1.yalcGlobal.yalcStoreMainDir = path_1.resolve(folder);
        console.log('Package store folder used:', _1.yalcGlobal.yalcStoreMainDir);
    }
})
    .command({
    command: '*',
    builder: function () {
        return yargs_1.default.boolean(['version']);
    },
    handler: function (argv) {
        var msg = 'Use `yalc help` to see available commands.';
        if (argv._[0]) {
            msg = 'Unknown command `' + argv._[0] + '`. ' + msg;
        }
        else {
            if (argv.version) {
                msg = getVersionMessage();
            }
        }
        console.log(msg);
    },
})
    .command({
    command: 'publish',
    describe: 'Publish package in yalc local repo',
    builder: function () {
        return yargs_1.default
            .default('sig', false)
            .default('scripts', true)
            .default('dev-mod', true)
            .default('workspace-resolve', true)
            .default(rcArgs)
            .alias('script', 'scripts')
            .boolean(['push'].concat(publishFlags));
    },
    handler: function (argv) {
        return _1.publishPackage(getPublishOptions(argv));
    },
})
    .command({
    command: 'push',
    describe: 'Publish package in yalc local repo and push to all installations',
    builder: function () {
        return yargs_1.default
            .default('sig', false)
            .default('scripts', false)
            .default('dev-mod', true)
            .default('workspace-resolve', true)
            .default(rcArgs)
            .alias('script', 'scripts')
            .boolean(['safe'].concat(publishFlags))
            .option('replace', { describe: 'Force package content replacement' });
    },
    handler: function (argv) {
        return _1.publishPackage(getPublishOptions(argv, { push: true }));
    },
})
    .command({
    command: 'installations',
    describe: 'Work with installations file: show/clean',
    builder: function () {
        return yargs_1.default.boolean(['dry']);
    },
    handler: function (argv) { return __awaiter(void 0, void 0, void 0, function () {
        var action, packages, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    action = argv._[1];
                    packages = argv._.slice(2);
                    _a = action;
                    switch (_a) {
                        case 'show': return [3 /*break*/, 1];
                        case 'clean': return [3 /*break*/, 2];
                    }
                    return [3 /*break*/, 4];
                case 1:
                    installations_1.showInstallations({ packages: packages });
                    return [3 /*break*/, 5];
                case 2: return [4 /*yield*/, installations_1.cleanInstallations({ packages: packages, dry: argv.dry })];
                case 3:
                    _b.sent();
                    return [3 /*break*/, 5];
                case 4:
                    console.info('Need installation action: show | clean');
                    _b.label = 5;
                case 5: return [2 /*return*/];
            }
        });
    }); },
})
    .command({
    command: 'add',
    describe: 'Add package from yalc repo to the project',
    builder: function () {
        return yargs_1.default
            .boolean(__spreadArrays(['file', 'dev', 'link'], updateFlags))
            .alias('D', 'dev')
            .boolean('workspace')
            .alias('save-dev', 'dev')
            .alias('workspace', 'W')
            .default(rcArgs)
            .help(true);
    },
    handler: function (argv) {
        var pure = !!argv.pure;
        return _1.addPackages(argv._.slice(1), {
            dev: argv.dev,
            linkDep: argv.link,
            restore: argv.restore,
            pure: pure,
            workspace: argv.workspace,
            update: argv.update || argv.upgrade,
            workingDir: process.cwd(),
        });
    },
})
    .command({
    command: 'link',
    describe: 'Link package from yalc repo to the project',
    builder: function () {
        return yargs_1.default.default(rcArgs).help(true);
    },
    handler: function (argv) {
        return _1.addPackages(argv._.slice(1), {
            link: true,
            pure: argv.pure,
            workingDir: process.cwd(),
        });
    },
})
    .command({
    command: 'update',
    describe: 'Update packages from yalc repo',
    builder: function () {
        return yargs_1.default
            .boolean(__spreadArrays(updateFlags))
            .default(rcArgs)
            .help(true);
    },
    handler: function (argv) {
        return _1.updatePackages(argv._.slice(1), {
            update: argv.update || argv.upgrade,
            restore: argv.restore,
            workingDir: process.cwd(),
        });
    },
})
    .command({
    command: 'restore',
    describe: 'Restore retreated packages',
    builder: function () {
        return yargs_1.default
            .boolean(__spreadArrays(updateFlags))
            .default(rcArgs)
            .help(true);
    },
    handler: function (argv) {
        return _1.updatePackages(argv._.slice(1), {
            update: argv.update || argv.upgrade,
            restore: true,
            workingDir: process.cwd(),
        });
    },
})
    .command({
    command: 'remove',
    describe: 'Remove packages from the project',
    builder: function () {
        return yargs_1.default.boolean(['retreat', 'all']).default(rcArgs).help(true);
    },
    handler: function (argv) {
        return _1.removePackages(argv._.slice(1), {
            retreat: argv.retreat,
            workingDir: process.cwd(),
            all: argv.all,
        });
    },
})
    .command({
    command: 'retreat',
    describe: 'Remove packages from project, but leave in lock file (to be restored later)',
    builder: function () {
        return yargs_1.default.boolean(['all']).help(true);
    },
    handler: function (argv) {
        return _1.removePackages(argv._.slice(1), {
            all: argv.all,
            retreat: true,
            workingDir: process.cwd(),
        });
    },
})
    .command({
    command: 'check',
    describe: 'Check package.json for yalc packages',
    builder: function () {
        return yargs_1.default.boolean(['commit']).usage('check usage here').help(true);
    },
    handler: function (argv) {
        var gitParams = process.env.GIT_PARAMS;
        if (argv.commit) {
            console.log('gitParams', gitParams);
        }
        check_1.checkManifest({
            commit: argv.commit,
            all: argv.all,
            workingDir: process.cwd(),
        });
    },
})
    .command({
    command: 'dir',
    describe: 'Show yalc system directory',
    handler: function () {
        console.log(_1.getStoreMainDir());
    },
})
    .help('help').argv;
//# sourceMappingURL=yalc.js.map