export declare type LockFileConfigV0 = {
    [packageName: string]: {
        version?: string;
        file?: boolean;
    };
};
export declare type LockFilePackageEntry = {
    version?: string;
    file?: boolean;
    link?: boolean;
    replaced?: string;
    signature?: string;
    pure?: boolean;
    workspace?: boolean;
};
export declare type LockFileConfigV1 = {
    version: 'v1';
    packages: {
        [packageName: string]: LockFilePackageEntry;
    };
};
declare type LockFileConfig = LockFileConfigV1;
export declare const removeLockfile: (options: {
    workingDir: string;
}) => void;
export declare const readLockfile: (options: {
    workingDir: string;
}) => LockFileConfigV1;
export declare const writeLockfile: (lockfile: LockFileConfig, options: {
    workingDir: string;
}) => void;
export declare const addPackageToLockfile: (packages: ({
    name: string;
} & LockFilePackageEntry)[], options: {
    workingDir: string;
}) => void;
export {};
