import { UmzugStorage } from './contract';
import { SetRequired } from 'type-fest';
interface ModelTempInterface extends ModelClass, Record<string, any> {
}
/**
 * Minimal structure of a sequelize model, defined here to avoid a hard dependency.
 * The type expected is `import { Model } from 'sequelize'`
 */
export interface ModelClass {
    tableName: string;
    sequelize?: SequelizeType;
    getTableName(): string;
    sync(): Promise<void>;
    findAll(options?: {}): Promise<any[]>;
    create(options: {}): Promise<void>;
    destroy(options: {}): Promise<void>;
}
/**
 * Minimal structure of a sequelize model, defined here to avoid a hard dependency.
 * The type expected is `import { Sequelize } from 'sequelize'`
 */
export interface SequelizeType {
    getQueryInterface(): any;
    isDefined(modelName: string): boolean;
    model(modelName: string): any;
    define(modelName: string, columns: {}, options: {}): {};
}
declare type ModelClassType = ModelClass & (new (values?: object, options?: any) => ModelTempInterface);
interface _SequelizeStorageConstructorOptions {
    /**
    The configured instance of Sequelize. If omitted, it is inferred from the `model` option.
    */
    readonly sequelize?: SequelizeType;
    /**
    The model representing the SequelizeMeta table. Must have a column that matches the `columnName` option. If omitted, it is created automatically.
    */
    readonly model?: any;
    /**
    The name of the model.

    @default 'SequelizeMeta'
    */
    readonly modelName?: string;
    /**
    The name of the table. If omitted, defaults to the model name.
    */
    readonly tableName?: string;
    /**
    Name of the schema under which the table is to be created.

    @default undefined
    */
    readonly schema?: any;
    /**
    Name of the table column holding the executed migration names.

    @default 'name'
    */
    readonly columnName?: string;
    /**
    The type of the column holding the executed migration names.

    For `utf8mb4` charsets under InnoDB, you may need to set this to less than 190

    @default Sequelize.DataTypes.STRING
    */
    readonly columnType?: any;
    /**
    Option to add timestamps to the table

    @default false
    */
    readonly timestamps?: boolean;
}
export declare type SequelizeStorageConstructorOptions = SetRequired<_SequelizeStorageConstructorOptions, 'sequelize'> | SetRequired<_SequelizeStorageConstructorOptions, 'model'>;
export declare class SequelizeStorage implements UmzugStorage {
    readonly sequelize: SequelizeType;
    readonly columnType: string;
    readonly columnName: string;
    readonly timestamps: boolean;
    readonly modelName: string;
    readonly tableName?: string;
    readonly schema: any;
    readonly model: ModelClassType;
    /**
    Constructs Sequelize based storage. Migrations will be stored in a SequelizeMeta table using the given instance of Sequelize.

    If a model is given, it will be used directly as the model for the SequelizeMeta table. Otherwise, it will be created automatically according to the given options.

    If the table does not exist it will be created automatically upon the logging of the first migration.
    */
    constructor(options: SequelizeStorageConstructorOptions);
    getModel(): ModelClassType;
    protected syncModel(): Promise<void>;
    logMigration({ name: migrationName }: {
        name: string;
    }): Promise<void>;
    unlogMigration({ name: migrationName }: {
        name: string;
    }): Promise<void>;
    executed(): Promise<string[]>;
    _model(): ModelClassType;
}
export {};
