import { jsxs, jsx } from 'react/jsx-runtime';
import { useState, Children } from 'react';
import { CarretDown } from '@strapi/icons';
import styled from 'styled-components';
import { useId } from '../../hooks/useId.mjs';
import { Box } from '../../Box/Box.mjs';
import { Flex } from '../../Flex/Flex.mjs';
import { Typography } from '../../Typography/Typography.mjs';

const SubNavLinkSectionWrapper = styled(Box) `
  svg {
    height: ${4 / 16}rem;
    path {
      fill: ${({ theme }) => theme.colors.neutral700};
    }
  }
`;
const SubNavLinkSectionButton = styled.button `
  border: none;
  padding: 0;
  background: transparent;
  display: flex;
  align-items: center;
`;
const DropDownIconWrapper = styled.div `
  display: flex;
  align-items: center;
  width: ${12 / 16}rem;
  transform: rotateX(${({ rotated }) => (rotated ? '0deg' : '180deg')});
`;
const SubNavLinkSection = ({ label, children, id }) => {
    const [isOpen, setOpenLinks] = useState(true);
    const listId = useId(id);
    const handleClick = () => {
        setOpenLinks((prev) => !prev);
    };
    return (jsxs(Box, { children: [jsx(SubNavLinkSectionWrapper, { paddingLeft: 7, paddingTop: 2, paddingBottom: 2, paddingRight: 4, children: jsx(Flex, { justifyContent: "space-between", children: jsxs(SubNavLinkSectionButton, { onClick: handleClick, "aria-expanded": isOpen, "aria-controls": listId, children: [jsx(DropDownIconWrapper, { rotated: isOpen, children: jsx(CarretDown, { "aria-hidden": true }) }), jsx(Box, { paddingLeft: 2, children: jsx(Typography, { as: "span", fontWeight: "semiBold", textColor: "neutral800", children: label }) })] }) }) }), isOpen && (jsx("ul", { id: listId, children: Children.map(children, (child, index) => {
                    // eslint-disable-next-line react/no-array-index-key
                    return jsx("li", { children: child }, index);
                }) }))] }));
};

export { SubNavLinkSection };
