'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Grid = require('../../Grid/Grid.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const subNavWidth = `${232 / 16}rem`;
const SubNavWrapper = styled__default.default(Grid.Grid) `
  width: ${subNavWidth};
  background: ${({ theme }) => theme.colors.neutral100};
  position: sticky;
  top: 0;
  height: 100vh;
  overflow-y: auto;
  border-right: 1px solid ${({ theme }) => theme.colors.neutral200};
  z-index: 1;
`;
const SubNav = ({ ariaLabel, ...props }) => {
    return jsxRuntime.jsx(SubNavWrapper, { "aria-label": ariaLabel, as: "nav", ...props });
};

exports.SubNav = SubNav;
exports.subNavWidth = subNavWidth;
