import { jsx, jsxs } from 'react/jsx-runtime';
import { forwardRef } from 'react';
import * as DropdownMenu from '@radix-ui/react-dropdown-menu';
import { CarretDown, ChevronRight } from '@strapi/icons';
import styled, { css } from 'styled-components';
import { extractStyleFromTheme } from '../../helpers/theme.mjs';
import { Link } from '../Link/Link.mjs';
import { Button } from '../../Button/Button.mjs';
import { Box } from '../../Box/Box.mjs';
import { Flex } from '../../Flex/Flex.mjs';
import { Typography } from '../../Typography/Typography.mjs';

const MenuRoot = DropdownMenu.Root;
const MenuTrigger = forwardRef(({ size, endIcon = jsx(CarretDown, { width: `${6 / 16}rem`, height: `${4 / 16}rem`, "aria-hidden": true }), ...props }, ref) => {
    return (jsx(DropdownMenu.Trigger, { asChild: true, children: jsx(Button, { ref: ref, type: "button", variant: "ghost", endIcon: endIcon, paddingTop: size === 'S' ? 1 : 2, paddingBottom: size === 'S' ? 1 : 2, paddingLeft: size === 'S' ? 3 : 4, paddingRight: size === 'S' ? 3 : 4, ...props }) }));
});
const MenuContent = forwardRef(({ children, intersectionId, popoverPlacement = 'bottom-start', ...props }, ref) => {
    const [side, align] = popoverPlacement.split('-');
    return (jsx(DropdownMenu.Portal, { children: jsx(DropdownMenu.Content, { align: align, side: side, loop: true, asChild: true, children: jsxs(Viewport, { ref: ref, direction: "column", borderStyle: "solid", borderWidth: "1px", borderColor: "neutral150", hasRadius: true, background: "neutral0", shadow: "filterShadow", maxHeight: "15rem", padding: 1, alignItems: "flex-start", position: "relative", overflow: "auto", ...props, children: [children, jsx(Box, { id: intersectionId, width: "100%", height: "1px" })] }) }) }));
});
const Viewport = styled(Flex) `
  scrollbar-width: none;
  -ms-overflow-style: none;
  -webkit-overflow-scrolling: touch;

  &::-webkit-scrollbar {
    display: none;
  }
`;
const MenuItem = ({ onSelect, disabled = false, ...props }) => {
    return (jsx(DropdownMenu.Item, { asChild: true, onSelect: onSelect, disabled: disabled, children: props.isLink || props.isExternal ? (jsx(OptionLink, { color: "neutral800", ...props, isExternal: props.isExternal ?? false, children: jsx(Typography, { children: props.children }) })) : (jsx(OptionButton, { cursor: "pointer", color: "neutral800", background: "transparent", borderStyle: "none", ...props, children: jsx(Typography, { children: props.children }) })) }));
};
const getOptionStyle = ({ theme }) => css `
  text-align: left;
  width: 100%;
  border-radius: ${theme.borderRadius};
  padding: ${theme.spaces[2]} ${theme.spaces[4]};

  ${Typography} {
    color: inherit;
  }

  &[aria-disabled] {
    cursor: not-allowed;

    ${Typography} {
      color: ${theme.colors.neutral500};
    }
  }

  &[data-highlighted] {
    background-color: ${theme.colors.primary100};
  }

  &:focus-visible {
    outline: none;

    &:after {
      content: none;
    }
  }
`;
const OptionButton = styled(Flex) `
  ${getOptionStyle}
`;
const OptionLink = styled(Link) `
  /* We include this here again because typically when people use OptionLink they provide an as prop which cancels the Box props */
  color: ${({ theme, color }) => extractStyleFromTheme(theme.colors, color, undefined)};
  text-decoration: none;

  &:hover {
    color: unset;
  }

  svg > path,
  &:focus-visible svg > path {
    fill: currentColor;
  }

  ${getOptionStyle}
`;
const MenuLabel = forwardRef((props, ref) => (jsx(DropdownMenu.Label, { asChild: true, children: jsx(StyledLabel, { ref: ref, variant: "sigma", textColor: "neutral600", ...props }) })));
const StyledLabel = styled(Typography) `
  padding: ${({ theme }) => theme.spaces[2]} ${({ theme }) => theme.spaces[4]};
`;
const MenuSubRoot = DropdownMenu.Sub;
const MenuSubTrigger = forwardRef(({ disabled = false, ...props }, ref) => {
    return (jsx(DropdownMenu.SubTrigger, { asChild: true, disabled: disabled, children: jsxs(SubmenuTrigger, { ref: ref, color: "neutral800", as: "button", type: "button", background: "transparent", borderStyle: "none", gap: 5, ...props, children: [jsx(Typography, { children: props.children }), jsx(TriggerArrow, { height: 12, width: 12 })] }) }));
});
const SubmenuTrigger = styled(OptionButton) `
  &[data-state='open'] {
    background-color: ${({ theme }) => theme.colors.primary100};
  }
`;
const TriggerArrow = styled(ChevronRight) `
  path {
    fill: ${({ theme }) => theme.colors.neutral500};
  }
`;
const MenuSubContent = forwardRef((props, ref) => {
    return (jsx(DropdownMenu.Portal, { children: jsx(DropdownMenu.SubContent, { sideOffset: 8, asChild: true, children: jsx(Viewport, { ref: ref, direction: "column", borderStyle: "solid", borderWidth: "1px", borderColor: "neutral150", hasRadius: true, background: "neutral0", shadow: "filterShadow", maxHeight: "15rem", padding: 1, alignItems: "flex-start", overflow: "auto", ...props }) }) }));
});
const Root = MenuRoot;
const Trigger = MenuTrigger;
const Content = MenuContent;
const Item = MenuItem;
const Label = MenuLabel;
const SubRoot = MenuSubRoot;
const SubTrigger = MenuSubTrigger;
const SubContent = MenuSubContent;

export { Content, Item, Label, Root, SubContent, SubRoot, SubTrigger, Trigger };
