'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const DropdownMenu = require('@radix-ui/react-dropdown-menu');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const theme = require('../../helpers/theme.js');
const Link = require('../Link/Link.js');
const Button = require('../../Button/Button.js');
const Box = require('../../Box/Box.js');
const Flex = require('../../Flex/Flex.js');
const Typography = require('../../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const DropdownMenu__namespace = /*#__PURE__*/_interopNamespace(DropdownMenu);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const MenuRoot = DropdownMenu__namespace.Root;
const MenuTrigger = React.forwardRef(({ size, endIcon = jsxRuntime.jsx(icons.CarretDown, { width: `${6 / 16}rem`, height: `${4 / 16}rem`, "aria-hidden": true }), ...props }, ref) => {
    return (jsxRuntime.jsx(DropdownMenu__namespace.Trigger, { asChild: true, children: jsxRuntime.jsx(Button.Button, { ref: ref, type: "button", variant: "ghost", endIcon: endIcon, paddingTop: size === 'S' ? 1 : 2, paddingBottom: size === 'S' ? 1 : 2, paddingLeft: size === 'S' ? 3 : 4, paddingRight: size === 'S' ? 3 : 4, ...props }) }));
});
const MenuContent = React.forwardRef(({ children, intersectionId, popoverPlacement = 'bottom-start', ...props }, ref) => {
    const [side, align] = popoverPlacement.split('-');
    return (jsxRuntime.jsx(DropdownMenu__namespace.Portal, { children: jsxRuntime.jsx(DropdownMenu__namespace.Content, { align: align, side: side, loop: true, asChild: true, children: jsxRuntime.jsxs(Viewport, { ref: ref, direction: "column", borderStyle: "solid", borderWidth: "1px", borderColor: "neutral150", hasRadius: true, background: "neutral0", shadow: "filterShadow", maxHeight: "15rem", padding: 1, alignItems: "flex-start", position: "relative", overflow: "auto", ...props, children: [children, jsxRuntime.jsx(Box.Box, { id: intersectionId, width: "100%", height: "1px" })] }) }) }));
});
const Viewport = styled__default.default(Flex.Flex) `
  scrollbar-width: none;
  -ms-overflow-style: none;
  -webkit-overflow-scrolling: touch;

  &::-webkit-scrollbar {
    display: none;
  }
`;
const MenuItem = ({ onSelect, disabled = false, ...props }) => {
    return (jsxRuntime.jsx(DropdownMenu__namespace.Item, { asChild: true, onSelect: onSelect, disabled: disabled, children: props.isLink || props.isExternal ? (jsxRuntime.jsx(OptionLink, { color: "neutral800", ...props, isExternal: props.isExternal ?? false, children: jsxRuntime.jsx(Typography.Typography, { children: props.children }) })) : (jsxRuntime.jsx(OptionButton, { cursor: "pointer", color: "neutral800", background: "transparent", borderStyle: "none", ...props, children: jsxRuntime.jsx(Typography.Typography, { children: props.children }) })) }));
};
const getOptionStyle = ({ theme }) => styled.css `
  text-align: left;
  width: 100%;
  border-radius: ${theme.borderRadius};
  padding: ${theme.spaces[2]} ${theme.spaces[4]};

  ${Typography.Typography} {
    color: inherit;
  }

  &[aria-disabled] {
    cursor: not-allowed;

    ${Typography.Typography} {
      color: ${theme.colors.neutral500};
    }
  }

  &[data-highlighted] {
    background-color: ${theme.colors.primary100};
  }

  &:focus-visible {
    outline: none;

    &:after {
      content: none;
    }
  }
`;
const OptionButton = styled__default.default(Flex.Flex) `
  ${getOptionStyle}
`;
const OptionLink = styled__default.default(Link.Link) `
  /* We include this here again because typically when people use OptionLink they provide an as prop which cancels the Box props */
  color: ${({ theme: theme$1, color }) => theme.extractStyleFromTheme(theme$1.colors, color, undefined)};
  text-decoration: none;

  &:hover {
    color: unset;
  }

  svg > path,
  &:focus-visible svg > path {
    fill: currentColor;
  }

  ${getOptionStyle}
`;
const MenuLabel = React.forwardRef((props, ref) => (jsxRuntime.jsx(DropdownMenu__namespace.Label, { asChild: true, children: jsxRuntime.jsx(StyledLabel, { ref: ref, variant: "sigma", textColor: "neutral600", ...props }) })));
const StyledLabel = styled__default.default(Typography.Typography) `
  padding: ${({ theme }) => theme.spaces[2]} ${({ theme }) => theme.spaces[4]};
`;
const MenuSubRoot = DropdownMenu__namespace.Sub;
const MenuSubTrigger = React.forwardRef(({ disabled = false, ...props }, ref) => {
    return (jsxRuntime.jsx(DropdownMenu__namespace.SubTrigger, { asChild: true, disabled: disabled, children: jsxRuntime.jsxs(SubmenuTrigger, { ref: ref, color: "neutral800", as: "button", type: "button", background: "transparent", borderStyle: "none", gap: 5, ...props, children: [jsxRuntime.jsx(Typography.Typography, { children: props.children }), jsxRuntime.jsx(TriggerArrow, { height: 12, width: 12 })] }) }));
});
const SubmenuTrigger = styled__default.default(OptionButton) `
  &[data-state='open'] {
    background-color: ${({ theme }) => theme.colors.primary100};
  }
`;
const TriggerArrow = styled__default.default(icons.ChevronRight) `
  path {
    fill: ${({ theme }) => theme.colors.neutral500};
  }
`;
const MenuSubContent = React.forwardRef((props, ref) => {
    return (jsxRuntime.jsx(DropdownMenu__namespace.Portal, { children: jsxRuntime.jsx(DropdownMenu__namespace.SubContent, { sideOffset: 8, asChild: true, children: jsxRuntime.jsx(Viewport, { ref: ref, direction: "column", borderStyle: "solid", borderWidth: "1px", borderColor: "neutral150", hasRadius: true, background: "neutral0", shadow: "filterShadow", maxHeight: "15rem", padding: 1, alignItems: "flex-start", overflow: "auto", ...props }) }) }));
});
const Root = MenuRoot;
const Trigger = MenuTrigger;
const Content = MenuContent;
const Item = MenuItem;
const Label = MenuLabel;
const SubRoot = MenuSubRoot;
const SubTrigger = MenuSubTrigger;
const SubContent = MenuSubContent;

exports.Content = Content;
exports.Item = Item;
exports.Label = Label;
exports.Root = Root;
exports.SubContent = SubContent;
exports.SubRoot = SubRoot;
exports.SubTrigger = SubTrigger;
exports.Trigger = Trigger;
