'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const MainNavContext = require('./MainNavContext.js');
const Box = require('../../Box/Box.js');
const Flex = require('../../Flex/Flex.js');
const Avatar = require('../../Avatar/Avatar.js');
const VisuallyHidden = require('../../VisuallyHidden/VisuallyHidden.js');
const Typography = require('../../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const NavUserBox = styled__default.default(Box.Box) `
  border-top: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const NavUser = React__default.default.forwardRef(({ src, children, initials, ...props }, ref) => {
    const condensed = MainNavContext.useMainNav();
    return (jsxRuntime.jsx(NavUserBox, { paddingTop: 3, paddingBottom: 3, paddingLeft: 5, paddingRight: 5, ...props, children: jsxRuntime.jsxs(Flex.Flex, { as: "button", justifyContent: condensed ? 'center' : undefined, ref: ref, children: [src ? jsxRuntime.jsx(Avatar.Avatar, { src: src, alt: "", "aria-hidden": true }) : jsxRuntime.jsx(Avatar.Initials, { children: initials }), condensed ? (jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: jsxRuntime.jsx("span", { children: children }) })) : (jsxRuntime.jsx(Box.Box, { width: `${130 / 16}rem`, paddingLeft: 2, as: "span", children: jsxRuntime.jsx(Typography.Typography, { ellipsis: true, textColor: "neutral600", children: children }) }))] }) }));
});

exports.NavUser = NavUser;
