'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const MainNavContext = require('./MainNavContext.js');
const BaseLink = require('../../BaseLink/BaseLink.js');
const Box = require('../../Box/Box.js');
const VisuallyHidden = require('../../VisuallyHidden/VisuallyHidden.js');
const Flex = require('../../Flex/Flex.js');
const Typography = require('../../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const BrandIconWrapper = styled__default.default.div `
  border-radius: ${({ theme }) => theme.borderRadius};

  svg,
  img {
    height: ${({ condensed }) => (condensed ? `${40 / 16}rem` : `${32 / 16}rem`)};
    width: ${({ condensed }) => (condensed ? `${40 / 16}rem` : `${32 / 16}rem`)};
  }
`;
const NavLinkWrapper = styled__default.default(BaseLink.BaseLink) `
  text-decoration: unset;
  color: inherit;
`;
const NavBrand = React__default.default.forwardRef(({ workplace, title, icon, ...props }, ref) => {
    const condensed = MainNavContext.useMainNav();
    /**
     * TODO: this shouldn't be here, because we're assuming you're
     * passing a ReactRouter Link which isn't necessarily the case.
     */
    props.to = props?.to ?? '/';
    if (condensed) {
        return (jsxRuntime.jsx(BaseLink.BaseLink, { ref: ref, ...props, children: jsxRuntime.jsx(Box.Box, { paddingLeft: 3, paddingRight: 3, paddingTop: 4, paddingBottom: 4, children: jsxRuntime.jsxs(BrandIconWrapper, { condensed: true, children: [icon, jsxRuntime.jsxs(VisuallyHidden.VisuallyHidden, { children: [jsxRuntime.jsx("span", { children: title }), jsxRuntime.jsx("span", { children: workplace })] })] }) }) }));
    }
    return (jsxRuntime.jsx(NavLinkWrapper, { ref: ref, ...props, children: jsxRuntime.jsx(Box.Box, { paddingLeft: 3, paddingRight: 3, paddingTop: 4, paddingBottom: 4, children: jsxRuntime.jsxs(Flex.Flex, { children: [jsxRuntime.jsx(BrandIconWrapper, { "aria-hidden": true, tabIndex: -1, children: icon }), jsxRuntime.jsxs(Box.Box, { paddingLeft: 2, children: [jsxRuntime.jsxs(Typography.Typography, { fontWeight: "bold", textColor: "neutral800", as: "span", children: [title, jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { as: "span", children: workplace })] }), jsxRuntime.jsx(Typography.Typography, { variant: "pi", as: "p", textColor: "neutral600", "aria-hidden": true, children: workplace })] })] }) }) }));
});

exports.NavBrand = NavBrand;
