import { jsxs, jsx } from 'react/jsx-runtime';
import React__default from 'react';
import styled from 'styled-components';
import { getDisabledStyle, getHoverStyle, getActiveStyle, getVariantStyle } from '../../Button/utils.mjs';
import { BaseButtonWrapper } from '../../BaseButton/BaseButton.mjs';
import { BaseLink } from '../../BaseLink/BaseLink.mjs';
import { Flex } from '../../Flex/Flex.mjs';
import { Typography } from '../../Typography/Typography.mjs';

const LinkWrapper = styled(BaseButtonWrapper) `
  text-decoration: none;

  &[aria-disabled='true'] {
    ${getDisabledStyle}
    &:active {
      ${getDisabledStyle}
    }
  }

  &:hover {
    ${getHoverStyle}
  }

  &:active {
    ${getActiveStyle}
  }

  ${getVariantStyle}
`;
const LinkButton = React__default.forwardRef(({ variant = 'default', startIcon, endIcon, disabled = false, children, size = 'S', as = BaseLink, ...props }, ref) => {
    const paddingX = size === 'S' ? 2 : '10px';
    const paddingY = 4;
    return (jsxs(LinkWrapper, { ref: ref, "aria-disabled": disabled, size: size, variant: variant, background: "buttonPrimary600", borderColor: "buttonPrimary600", hasRadius: true, gap: 2, inline: true, paddingBottom: paddingX, paddingLeft: paddingY, paddingRight: paddingY, paddingTop: paddingX, pointerEvents: disabled ? 'none' : undefined, ...props, as: as || BaseLink, children: [startIcon && jsx(Flex, { "aria-hidden": true, children: startIcon }), jsx(Typography, { variant: size === 'S' ? 'pi' : undefined, fontWeight: "bold", textColor: "buttonNeutral0", children: children }), endIcon && jsx(Flex, { "aria-hidden": true, children: endIcon })] }));
});
LinkButton.displayName = 'LinkButton';

export { LinkButton };
