import { jsxs, jsx } from 'react/jsx-runtime';
import React__default from 'react';
import { ExternalLink } from '@strapi/icons';
import styled from 'styled-components';
import { buttonFocusStyle } from '../../themes/utils.mjs';
import { BaseLink } from '../../BaseLink/BaseLink.mjs';
import { Typography } from '../../Typography/Typography.mjs';

const LinkWrapper = styled(BaseLink) `
  display: inline-flex;
  align-items: center;
  text-decoration: none;
  gap: ${({ theme }) => theme.spaces[2]};
  pointer-events: ${({ disabled }) => (disabled ? 'none' : undefined)};

  svg {
    font-size: ${10 / 16}rem;

    path {
      fill: ${({ disabled, theme }) => (disabled ? theme.colors.neutral600 : theme.colors.primary600)};
    }
  }

  &:hover {
    color: ${({ theme }) => theme.colors.primary500};
  }

  &:active {
    color: ${({ theme }) => theme.colors.primary700};
  }

  ${buttonFocusStyle};
`;
const Link = React__default.forwardRef(({ children, href, disabled = false, startIcon, endIcon, isExternal = true, ...props }, ref) => {
    return (jsxs(LinkWrapper, { ref: ref, href: href, disabled: disabled, isExternal: isExternal, ...props, children: [startIcon, jsx(Typography, { textColor: disabled ? 'neutral600' : 'primary600', children: children }), endIcon, href && !endIcon && isExternal && jsx(ExternalLink, {})] }));
});
Link.displayName = 'Link';

export { Link };
