'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const utils = require('../../themes/utils.js');
const BaseLink = require('../../BaseLink/BaseLink.js');
const Typography = require('../../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const LinkWrapper = styled__default.default(BaseLink.BaseLink) `
  display: inline-flex;
  align-items: center;
  text-decoration: none;
  gap: ${({ theme }) => theme.spaces[2]};
  pointer-events: ${({ disabled }) => (disabled ? 'none' : undefined)};

  svg {
    font-size: ${10 / 16}rem;

    path {
      fill: ${({ disabled, theme }) => (disabled ? theme.colors.neutral600 : theme.colors.primary600)};
    }
  }

  &:hover {
    color: ${({ theme }) => theme.colors.primary500};
  }

  &:active {
    color: ${({ theme }) => theme.colors.primary700};
  }

  ${utils.buttonFocusStyle};
`;
const Link = React__default.default.forwardRef(({ children, href, disabled = false, startIcon, endIcon, isExternal = true, ...props }, ref) => {
    return (jsxRuntime.jsxs(LinkWrapper, { ref: ref, href: href, disabled: disabled, isExternal: isExternal, ...props, children: [startIcon, jsxRuntime.jsx(Typography.Typography, { textColor: disabled ? 'neutral600' : 'primary600', children: children }), endIcon, href && !endIcon && isExternal && jsxRuntime.jsx(icons.ExternalLink, {})] }));
});
Link.displayName = 'Link';

exports.Link = Link;
