import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { SimpleMenu } from '../SimpleMenu/SimpleMenu.mjs';
import { Button } from '../../Button/Button.mjs';

const StyledButton = styled(Button) `
  padding: ${({ theme }) => `${theme.spaces[1]} ${theme.spaces[2]}`};
  height: unset;

  :hover,
  :focus {
    background-color: ${({ theme }) => theme.colors.neutral200};
  }
`;
const CrumbSimpleMenu = ({ children, ...props }) => (jsx(SimpleMenu, { endIcon: null, as: StyledButton, size: "S", ...props, children: children }));
CrumbSimpleMenu.displayName = 'CrumbSimpleMenu';

export { CrumbSimpleMenu };
