'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const BaseLink = require('../../BaseLink/BaseLink.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const StyledLink = styled__default.default(BaseLink.BaseLink) `
  border-radius: ${({ theme }) => theme.borderRadius};
  color: ${({ theme }) => theme.colors.neutral600};
  font-size: ${({ theme }) => theme.fontSizes[1]};
  line-height: ${({ theme }) => theme.lineHeights[4]};
  padding: ${({ theme }) => `${theme.spaces[1]} ${theme.spaces[2]}`};
  text-decoration: none;

  :hover,
  :focus {
    background-color: ${({ theme }) => theme.colors.neutral200};
    color: ${({ theme }) => theme.colors.neutral700};
  }
`;
const CrumbLink = ({ children, ...props }) => jsxRuntime.jsx(StyledLink, { ...props, children: children });
CrumbLink.displayName = 'CrumbLink';

exports.CrumbLink = CrumbLink;
