import { jsx } from 'react/jsx-runtime';
import { Box } from '../../Box/Box.mjs';
import { Typography } from '../../Typography/Typography.mjs';

const Crumb = ({ children, isCurrent = false, ...props }) => (jsx(Box, { paddingLeft: 2, paddingRight: 2, paddingTop: 1, paddingBottom: 1, children: jsx(Typography, { variant: "pi", textColor: "neutral800", fontWeight: isCurrent ? 'bold' : 'normal', "aria-current": isCurrent, ...props, children: children }) }));
Crumb.displayName = 'Crumb';

export { Crumb };
