'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const deprecations = require('./deprecations.js');
const useResizeObserver$1 = require('../hooks/useResizeObserver.js');

const warnDeprecated = deprecations.once(console.warn);
/**
 * @preserve
 * @deprecated useResizeObserver has moved. Please import it from "@strapi/design-system/hooks/useResizeObserver"
 */
const useResizeObserver = (...args) => {
    warnDeprecated(`${deprecations.PREFIX} useResizeObserver has moved. Please import it from "@strapi/design-system/hooks/useResizeObserver"`);
    return useResizeObserver$1.useResizeObserver(...args);
};

exports.useResizeObserver = useResizeObserver;
