import { once, PREFIX } from './deprecations.mjs';
import { useElementOnScreen as useElementOnScreen$1 } from '../hooks/useElementOnScreen.mjs';

const warnDeprecated = once(console.warn);
/**
 * @preserve
 * @deprecated useElementOnScreen has moved. Please import it from "@strapi/design-system/hooks/useElementOnScreen"
 */
const useElementOnScreen = (...args) => {
    warnDeprecated(`${PREFIX} useElementOnScreen has moved. Please import it from "@strapi/design-system/hooks/useElementOnScreen"`);
    return useElementOnScreen$1(...args);
};

export { useElementOnScreen };
