/* eslint-disable consistent-return */
const handleResponsiveValues = (property, value, theme) => {
    if (!value) {
        return undefined;
    }
    if (typeof value === 'object') {
        const transformedArray = Array.isArray(value)
            ? value
            : [value?.desktop, value?.tablet, value?.mobile];
        const spaces = transformedArray.reduce((acc, curr, index) => {
            if (curr) {
                switch (index) {
                    case 0:
                        return `${acc}${property}: ${theme.spaces[curr]};`;
                    case 1:
                        return `${acc}${theme.mediaQueries.tablet}{${property}: ${theme.spaces[curr]};}`;
                    case 2:
                        return `${acc}${theme.mediaQueries.mobile}{${property}: ${theme.spaces[curr]};}`;
                    default:
                        return acc;
                }
            }
            return acc;
        }, '');
        return spaces;
    }
    // Fallback to the passed transformedArray when necessary
    const realValue = theme.spaces[value] ?? value;
    return `${property}: ${realValue};`;
};

export { handleResponsiveValues as default };
