'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const React = require('react');
const positionTooltip = require('../utils/positionTooltip.js');

const useTooltipLayout = (visible, position) => {
    const tooltipWrapperRef = React.useRef(null);
    const toggleSourceRef = React.useRef(null);
    React.useLayoutEffect(() => {
        if (visible) {
            const tooltip = tooltipWrapperRef.current;
            const toggleSource = toggleSourceRef.current;
            if (tooltip && toggleSource) {
                const tooltipPosition = positionTooltip.positionTooltip(tooltip, toggleSource, position);
                tooltip.style.left = `${tooltipPosition.left}px`;
                tooltip.style.top = `${tooltipPosition.top}px`;
            }
        }
    }, [position, visible]);
    return { tooltipWrapperRef, toggleSourceRef };
};

exports.useTooltipLayout = useTooltipLayout;
