'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const utils = require('../themes/utils.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');
const FieldContext = require('../Field/FieldContext.js');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const Label = styled__default.default.label `
  position: relative;
  display: inline-block;
  z-index: 0;
  width: 100%;
`;
const ToggleCheckboxWrapper = styled__default.default(Box.Box) `
  cursor: ${({ disabled }) => (disabled ? 'not-allowed' : undefined)};
  // Masks the background of each value
  overflow: hidden;
  flex-wrap: wrap;

  ${utils.inputFocusStyle()}
`;
const ValueBox = styled__default.default(Flex.Flex).attrs({
    hasRadius: true,
}) `
  background-color: ${({ theme, checked, disabled }) => {
    if (checked) {
        return disabled ? theme.colors.neutral200 : theme.colors.neutral0;
    }
    return 'transparent';
}};
  border: 1px solid
    ${({ theme, checked, disabled }) => {
    if (checked && checked !== null) {
        return disabled ? theme.colors.neutral300 : theme.colors.neutral200;
    }
    return disabled ? theme.colors.neutral150 : theme.colors.neutral100;
}};
  position: relative;
  user-select: none;
  z-index: 2;
  flex: 1 1 50%;
  /**
    We declare the defined value because we want the height of the input when 
    the values are in a row to be 40px. But defining a height on the label
    would break the input when it wraps.
  */
  padding-top: ${({ size }) => `${size === 'S' ? '2px' : '6px'}`};
  padding-bottom: ${({ size }) => `${size === 'S' ? '2px' : '6px'}`};
`;
/**
 * visually hiding the input without SR-only helps Android SR to provide information with touch and haptic
 */
const Input = styled__default.default.input `
  height: 100%;
  left: 0;
  opacity: 0;
  position: absolute;
  top: 0;
  z-index: 1;
  width: 100%;
`;
const ToggleCheckbox = React__default.default.forwardRef(({ size = 'M', onLabel, offLabel, children, checked = false, disabled = false, onChange, ...props }, ref) => {
    const { error, hint, id, name, required } = FieldContext.useField();
    const labelColor = 'neutral600';
    let offCheckboxLabelColor = !checked && checked !== null ? 'danger700' : labelColor;
    let onCheckboxLabelColor = checked ? 'primary600' : labelColor;
    const handleChange = (e) => {
        if (disabled)
            return;
        if (onChange) {
            onChange(e);
        }
    };
    // Ensuring we pass the right aria-describedby attribute to the Input component as
    // ToggleCheckbox is not using FieldInput which would allow us to pass on the error or hint with aria-describedby
    let ariaDescription;
    if (error) {
        ariaDescription = `${id}-error`;
    }
    else if (hint) {
        ariaDescription = `${id}-hint`;
    }
    return (jsxRuntime.jsxs(Label, { children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsxs(ToggleCheckboxWrapper, { hasRadius: true, disabled: disabled, padding: 1, display: "flex", background: disabled ? 'neutral150' : 'neutral100', borderStyle: "solid", borderWidth: "1px", borderColor: "neutral200", hasError: Boolean(error), children: [jsxRuntime.jsx(ValueBox, { size: size, paddingLeft: 3, paddingRight: 3, justifyContent: "center", alignItems: "center", "aria-hidden": true, checked: checked === null ? false : !checked, disabled: disabled, children: jsxRuntime.jsx(Typography.Typography, { variant: "pi", fontWeight: "bold", textTransform: "uppercase", textColor: disabled ? 'neutral700' : offCheckboxLabelColor, children: offLabel }) }), jsxRuntime.jsx(ValueBox, { size: size, paddingLeft: 3, paddingRight: 3, justifyContent: "center", alignItems: "center", "aria-hidden": true, checked: checked === null ? false : checked, disabled: disabled, children: jsxRuntime.jsx(Typography.Typography, { variant: "pi", fontWeight: "bold", textTransform: "uppercase", textColor: disabled ? 'neutral700' : onCheckboxLabelColor, children: onLabel }) }), jsxRuntime.jsx(Input, { type: "checkbox", "aria-disabled": disabled, "aria-describedby": ariaDescription, onChange: (e) => handleChange(e), name: name, ref: ref, "aria-required": required, ...props, checked: !(checked === null || !checked) })] })] }));
});
ToggleCheckbox.displayName = 'ToggleCheckbox';

exports.ToggleCheckbox = ToggleCheckbox;
