'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const Combobox = require('../Combobox/Combobox.js');
const DesignSystemProvider = require('../DesignSystemProvider.js');
const useControllableState = require('../hooks/useControllableState.js');
const useDateFormatter = require('../hooks/useDateFormatter.js');
const useId = require('../hooks/useId.js');
const Field = require('../Field/Field.js');
const Flex = require('../Flex/Flex.js');
const FieldLabel = require('../Field/FieldLabel.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const isNotAlphabeticalCharacter = (str) => {
    return Boolean(str.match(/^[^a-zA-Z]*$/));
};
const TimePickerInput = React__namespace.forwardRef(({ id, step = 15, 
/**
 * @preserve
 * @deprecated This is no longer used.
 */
ariaLabel: _ariaLabel, 
/**
 * @preserve
 * @deprecated This is no longer used.
 */
selectButtonTitle: _selectButtonTitle, value: valueProp, defaultValue, onChange, ...restProps }, forwardedRef) => {
    const context = DesignSystemProvider.useDesignSystem('TimePicker');
    const generatedId = useId.useId(id);
    const [textValue, setTextValue] = React__namespace.useState('');
    const [value, setValue] = useControllableState.useControllableState({
        prop: valueProp,
        defaultProp: defaultValue,
        onChange,
    });
    const formatter = useDateFormatter.useDateFormatter(context.locale, {
        hour: '2-digit',
        minute: '2-digit',
        hour12: false,
    });
    const separator = React__namespace.useMemo(() => {
        const parts = formatter.formatToParts(new Date());
        const { value: separator } = parts.find((part) => part.type === 'literal');
        return separator;
    }, [formatter]);
    const timeOptions = React__namespace.useMemo(() => {
        const stepCount = 60 / step;
        return [...Array(24).keys()].flatMap((hour) => [...Array(stepCount).keys()].map((minuteStep) => formatter.format(new Date(0, 0, 0, hour, minuteStep * step))));
    }, [step, formatter]);
    const handleTextValueChange = (string) => {
        if (!string || isNotAlphabeticalCharacter(string)) {
            setTextValue(string);
        }
    };
    const createNewTimeValue = (value) => {
        const [hours, minutes] = value.split(separator);
        if (!hours && !minutes)
            return undefined;
        const hoursAsNumber = Number(hours ?? '0');
        const minutesAsNumber = Number(minutes ?? '0');
        if (hoursAsNumber > 23 || minutesAsNumber > 59)
            return undefined;
        return formatter.format(new Date(0, 0, 0, hoursAsNumber, minutesAsNumber));
    };
    const handleBlur = (event) => {
        const newValue = createNewTimeValue(event.target.value);
        if (newValue) {
            setTextValue(newValue);
            setValue(newValue);
        }
        else {
            setTextValue(value);
        }
    };
    const handleChange = (changedValue) => {
        if (typeof changedValue !== 'undefined') {
            const newValue = createNewTimeValue(changedValue);
            setValue(newValue);
        }
        else {
            setValue(changedValue);
        }
    };
    /**
     * Because we allow values that aren't necessarily in the list & we control the text value, we need to
     * update the text value when the value changes to keep the two in sync.
     */
    React__namespace.useEffect(() => {
        const actualValue = typeof valueProp === 'undefined' ? '' : valueProp;
        if (isNotAlphabeticalCharacter(actualValue)) {
            setTextValue(actualValue);
        }
    }, [valueProp, setTextValue]);
    return (jsxRuntime.jsx(Combobox.ComboboxInput, { ...restProps, ref: forwardedRef, value: value, onChange: handleChange, isPrintableCharacter: isNotAlphabeticalCharacter, allowCustomValue: true, placeholder: `--${separator}--`, autocomplete: "none", startIcon: jsxRuntime.jsx(StyledClock, {}), id: generatedId, inputMode: "numeric", pattern: `\\d{2}\\${separator}\\d{2}`, textValue: textValue, onTextValueChange: handleTextValueChange, onBlur: handleBlur, children: timeOptions.map((time) => (jsxRuntime.jsx(Combobox.Option, { value: time, children: time }, time))) }));
});
const StyledClock = styled__default.default(icons.Clock) `
  height: 1rem;
  width: 1rem;

  & > path {
    fill: ${({ theme }) => theme.colors.neutral500};
  }
`;
const TimePicker = React__namespace.forwardRef(({ label, error, hint, id, required, labelAction, ...restProps }, forwardedRef) => {
    const generatedId = useId.useId(id);
    return (jsxRuntime.jsx(Field.Field, { hint: hint, error: error, id: generatedId, required: required, children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [jsxRuntime.jsx(FieldLabel.FieldLabel, { action: labelAction, children: label }), jsxRuntime.jsx(TimePickerInput, { ref: forwardedRef, id: generatedId, error: error, required: required, ...restProps }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});

exports.TimePicker = TimePicker;
exports.TimePickerInput = TimePickerInput;
