'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const utils = require('../themes/utils.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const rotation = styled.keyframes `
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(359deg);
  }
`;
const LoadingWrapper = styled__default.default.div `
  animation: ${rotation} 2s infinite linear;
  will-change: transform;
`;
const TextButtonWrapper = styled__default.default(Flex.Flex) `
  border: none;

  &[aria-disabled='true'] {
    pointer-events: none;
    svg path {
      fill: ${({ theme }) => theme.colors.neutral600};
    }
  }

  svg path {
    fill: ${({ theme }) => theme.colors.primary600};
  }

  ${utils.buttonFocusStyle}
`;
const TextButton = React__namespace.forwardRef(({ children, startIcon, endIcon, onClick, disabled = false, loading = false, ...props }, ref) => {
    const handleClick = onClick && !disabled ? onClick : undefined;
    const isDisabled = disabled || loading;
    return (jsxRuntime.jsxs(TextButtonWrapper, { ref: ref, "aria-disabled": isDisabled, onClick: handleClick, as: "button", type: "button", background: "transparent", gap: 2, ...props, children: [loading ? (jsxRuntime.jsx(LoadingWrapper, { "aria-hidden": true, children: jsxRuntime.jsx(icons.Loader, {}) })) : (startIcon), jsxRuntime.jsx(Typography.Typography, { variant: "pi", textColor: isDisabled ? 'neutral600' : 'primary600', children: children }), endIcon] }));
});
TextButton.displayName = 'TextButton';

exports.TextButton = TextButton;
