import { jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { TabsContext } from './TabsContext.mjs';
import { useId } from '../hooks/useId.mjs';

const TabGroup = React.forwardRef(({ id, initialSelectedTabIndex = 0, label, onTabChange, variant, ...props }, ref) => {
    const tabsId = useId(id);
    const [selectedTabIndex, setSelectedTabIndex] = React.useState(initialSelectedTabIndex);
    React.useImperativeHandle(ref, () => ({
        _handlers: { setSelectedTabIndex },
    }));
    const context = React.useMemo(() => ({ id: tabsId, selectedTabIndex, selectTabIndex: setSelectedTabIndex, label, variant, onTabChange }), [label, onTabChange, selectedTabIndex, tabsId, variant]);
    return (jsx(TabsContext.Provider, { value: context, children: jsx("div", { ...props }) }));
});
TabGroup.displayName = 'TabGroup';

export { TabGroup };
