import { jsx, jsxs } from 'react/jsx-runtime';
import styled from 'styled-components';
import { RawTd, RawTh } from '../RawTable/RawCell.mjs';
import { Flex } from '../Flex/Flex.mjs';

const CellWrapper = styled(RawTd) `
  vertical-align: middle;
  text-align: left;
  color: ${({ theme }) => theme.colors.neutral600};
  outline-offset: -4px;

  /**
  * Hack to make sure the checkbox looks aligned
  */
  input {
    vertical-align: sub;
  }
`;
const ActionWrapper = styled.span `
  svg {
    height: ${4 / 16}rem;
  }
`;
const Th = ({ children, action, ...props }) => {
    return (jsx(CellWrapper, { as: RawTh, ...props, children: jsxs(Flex, { children: [children, jsx(ActionWrapper, { children: action })] }) }));
};
const Td = ({ children, ...props }) => {
    return jsx(CellWrapper, { ...props, children: children });
};

export { Td, Th };
