'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const Flex = require('../Flex/Flex.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const SwitchContent = styled__default.default.div `
  background: ${({ theme }) => theme.colors.danger500};
  border: none;
  border-radius: 16px;
  position: relative;
  height: ${24 / 16}rem;
  width: ${40 / 16}rem;

  & span {
    font-size: ${({ visibleLabels }) => (visibleLabels ? '1rem' : 0)};
  }

  &:before {
    content: '';
    background: ${({ theme }) => theme.colors.neutral0};
    width: 1rem;
    height: 1rem;
    border-radius: 50%;
    position: absolute;
    transition: all 0.5s;
    left: ${({ theme }) => theme.spaces[1]};
    top: ${({ theme }) => theme.spaces[1]};
  }

  @media (prefers-reduced-motion: reduce) {
    &:before {
      transition: none;
    }
  }
`;
const SwitchButton = styled__default.default.button `
  background: transparent;
  padding: 0;
  border: none;

  &[aria-checked='true'] ${SwitchContent} {
    background: ${({ theme }) => theme.colors.success500};
  }

  &[aria-checked='true'] ${SwitchContent}:before {
    transform: translateX(1rem);
  }
`;
const Switch = React__default.default.forwardRef(({ label, onChange, onLabel = 'On', offLabel = 'Off', selected, visibleLabels = false, ...props }, ref) => {
    return (jsxRuntime.jsx(SwitchButton, { ref: ref, role: "switch", "aria-checked": selected, "aria-label": label, onClick: onChange, visibleLabels: visibleLabels, type: "button", ...props, children: jsxRuntime.jsxs(Flex.Flex, { children: [jsxRuntime.jsxs(SwitchContent, { children: [jsxRuntime.jsx("span", { children: onLabel }), jsxRuntime.jsx("span", { children: offLabel })] }), visibleLabels && (jsxRuntime.jsx(Box.Box, { as: "span", "aria-hidden": true, paddingLeft: 2, color: selected ? 'success600' : 'danger600', children: selected ? onLabel : offLabel }))] }) }));
});

exports.Switch = Switch;
