import { jsxs, jsx } from 'react/jsx-runtime';
import { useState, useRef, useEffect } from 'react';
import { Search } from '@strapi/icons';
import styled from 'styled-components';
import { KeyboardKeys } from '../helpers/keyboardKeys.mjs';
import { useId } from '../hooks/useId.mjs';
import { usePrevious } from '../hooks/usePrevious.mjs';
import { SearchForm } from '../Searchbar/SearchForm.mjs';
import { Searchbar } from '../Searchbar/Searchbar.mjs';
import { Divider } from '../Divider/Divider.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';
import { IconButton } from '../IconButton/IconButton.mjs';

const CustomDivider = styled(Divider) `
  width: ${24 / 16}rem;
  background-color: ${({ theme }) => theme.colors.neutral200};
`;
const SubNavHeader = ({ as = 'h2', label, searchLabel = '', searchable, onChange = () => { }, value = '', onClear = () => { }, onSubmit = () => { }, id, }) => {
    const [isSearchOpen, setSearchOpen] = useState(false);
    const previousSearchOpenValue = usePrevious(isSearchOpen);
    const clearButtonId = useId(id);
    const searchRef = useRef(null);
    const searchButtonRef = useRef(null);
    useEffect(() => {
        if (isSearchOpen && searchRef.current) {
            searchRef.current.focus();
        }
        if (previousSearchOpenValue && !isSearchOpen && searchButtonRef.current) {
            searchButtonRef.current.focus();
        }
    }, [isSearchOpen, previousSearchOpenValue]);
    const toggleSearch = () => {
        setSearchOpen((isOpen) => !isOpen);
    };
    const handleClear = (e) => {
        onClear(e);
        if (searchRef?.current) {
            searchRef.current.focus();
        }
    };
    const handleBlur = (e) => {
        if (e.relatedTarget?.id !== clearButtonId) {
            setSearchOpen(false);
        }
    };
    const handleKeyDown = (e) => {
        if (e.key === KeyboardKeys.ESCAPE) {
            setSearchOpen(false);
        }
    };
    if (isSearchOpen) {
        return (jsxs(Box, { paddingLeft: 4, paddingTop: 5, paddingBottom: 2, paddingRight: 4, children: [jsx(SearchForm, { children: jsx(Searchbar, { name: "searchbar", value: value, onChange: onChange, placeholder: "e.g: strapi-plugin-abcd", onKeyDown: handleKeyDown, ref: searchRef, onBlur: handleBlur, onClear: handleClear, onSubmit: onSubmit, clearLabel: "Clear", size: "S", children: searchLabel }) }), jsx(Box, { paddingLeft: 2, paddingTop: 4, children: jsx(CustomDivider, {}) })] }));
    }
    return (jsxs(Box, { paddingLeft: 6, paddingTop: 6, paddingBottom: 2, paddingRight: 4, children: [jsxs(Flex, { justifyContent: "space-between", alignItems: "flex-start", children: [jsx(Typography, { variant: "beta", as: as, children: label }), searchable && (jsx(IconButton, { ref: searchButtonRef, onClick: toggleSearch, label: searchLabel, icon: jsx(Search, {}) }))] }), jsx(Box, { paddingTop: 4, children: jsx(CustomDivider, {}) })] }));
};

export { SubNavHeader };
