'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const MultiSelect = require('./MultiSelect.js');
const SingleSelect = require('./SingleSelect.js');

function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
    if (e) {
        for (const k in e) {
            if (k !== 'default') {
                const d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: () => e[k]
                });
            }
        }
    }
    n.default = e;
    return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);

const SelectContext = React__namespace.createContext({ multi: false });
const useSelectContext = () => React__namespace.useContext(SelectContext);
/**
 * @preserve
 * @deprecated You should import the specific type of select you want to render
 *
 * e.g. `import { MultiSelect } from '@strapi/design-system';`
 */
const Select = (props) => {
    const contextValue = React__namespace.useMemo(() => ({ multi: Boolean(props.multi || props.withTags) }), [props.multi, props.withTags]);
    return (jsxRuntime.jsx(SelectContext.Provider, { value: contextValue, children: props.multi || props.withTags ? jsxRuntime.jsx(MultiSelect.MultiSelect, { ...props }) : jsxRuntime.jsx(SingleSelect.SingleSelect, { ...props }) }));
};

exports.Select = Select;
exports.useSelectContext = useSelectContext;
