'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');

const RawTbody = ({ children, ...props }) => {
    /**
     * aria-rowindex is 1-based: we have to start from 1
     * since the <tr><th></th></tr> elements count as 1 row, we have to increment the index by 2 (because of the base 1 AND the th)
     */
    const childrenClone = React.Children.toArray(children).map((child, index) => {
        if (React.isValidElement(child)) {
            return React.cloneElement(child, { 'aria-rowindex': index + 2 });
        }
        return child;
    });
    return jsxRuntime.jsx("tbody", { ...props, children: childrenClone });
};

exports.RawTbody = RawTbody;
