'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const PaginationContext = require('./PaginationContext.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');

function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
    if (e) {
        for (const k in e) {
            if (k !== 'default') {
                const d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: () => e[k]
                });
            }
        }
    }
    n.default = e;
    return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);

const Pagination = ({ children, label = 'Pagination', activePage, pageCount }) => {
    const context = React__namespace.useMemo(() => ({ activePage, pageCount }), [activePage, pageCount]);
    return (jsxRuntime.jsx(PaginationContext.PaginationContext.Provider, { value: context, children: jsxRuntime.jsx(Box.Box, { "aria-label": label, as: "nav", children: jsxRuntime.jsx(Flex.Flex, { as: "ol", gap: 1, children: React__namespace.Children.map(children, (child, index) => {
                    // eslint-disable-next-line react/no-array-index-key
                    return jsxRuntime.jsx("li", { children: child }, index);
                }) }) }) }));
};

exports.Pagination = Pagination;
