import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { ModalContext } from './ModalContext.mjs';
import { DismissibleLayer } from '../DismissibleLayer/index.mjs';
import useLockScroll from '../hooks/useLockScroll.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Portal } from '../Portal/Portal.mjs';
import { FocusTrap } from '../FocusTrap/FocusTrap.mjs';
import { Box } from '../Box/Box.mjs';

const ModalWrapper = styled(Flex) `
  background: ${({ theme }) => `${theme.colors.neutral800}1F`};
  inset: 0;
`;
const ModalLayout = ({ onClose, labelledBy, ...props }) => {
    useLockScroll(true);
    return (jsx(Portal, { children: jsx(ModalContext.Provider, { value: onClose, children: jsx(ModalWrapper, { justifyContent: "center", paddingLeft: 8, paddingRight: 8, position: "fixed", zIndex: 4, children: jsx(FocusTrap, { children: jsx(DismissibleLayer, { onEscapeKeyDown: onClose, onPointerDownOutside: onClose, children: jsx(Box, { "aria-labelledby": labelledBy, "aria-modal": true, onClick: (e) => e.stopPropagation(), background: "neutral0", hasRadius: true, role: "dialog", shadow: "popupShadow", width: `${830 / 16}rem`, ...props }) }) }) }) }) }));
};

export { ModalLayout };
