import { jsx, jsxs } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';

const ModalFooterWrapper = styled(Box) `
  border-radius: 0 0 ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius};
  border-top: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const ModalFooter = ({ startActions, endActions }) => {
    return (jsx(ModalFooterWrapper, { paddingTop: 4, paddingBottom: 4, paddingLeft: 5, paddingRight: 5, background: "neutral100", children: jsxs(Flex, { justifyContent: "space-between", children: [jsx(Flex, { gap: 2, children: startActions }), jsx(Flex, { gap: 2, children: endActions })] }) }));
};

export { ModalFooter };
