import { jsx, jsxs } from 'react/jsx-runtime';
import React__default from 'react';
import styled from 'styled-components';
import { useMainNav } from './MainNavContext.mjs';
import { Avatar, Initials } from '../Avatar/Avatar.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';
import { Typography } from '../Typography/Typography.mjs';

const NavUserBox = styled(Box) `
  border-top: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const NavUser = React__default.forwardRef(({ src, children, initials, ...props }, ref) => {
    const condensed = useMainNav();
    return (jsx(NavUserBox, { paddingTop: 3, paddingBottom: 3, paddingLeft: 5, paddingRight: 5, ...props, children: jsxs(Flex, { as: "button", justifyContent: condensed ? 'center' : undefined, ref: ref, children: [src ? jsx(Avatar, { src: src, alt: "", "aria-hidden": true }) : jsx(Initials, { children: initials }), condensed ? (jsx(VisuallyHidden, { children: jsx("span", { children: children }) })) : (jsx(Box, { width: `${130 / 16}rem`, paddingLeft: 2, as: "span", children: jsx(Typography, { ellipsis: true, textColor: "neutral600", children: children }) }))] }) }));
});

export { NavUser };
