'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const reactRouterDom = require('react-router-dom');
const styled = require('styled-components');
const MainNavContext = require('./MainNavContext.js');
const Box = require('../Box/Box.js');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const BrandIconWrapper = styled__default.default.div `
  svg,
  img {
    border-radius: ${({ theme }) => theme.borderRadius};
    object-fit: contain;
    height: ${({ condensed }) => (condensed ? `${40 / 16}rem` : `${32 / 16}rem`)};
    width: ${({ condensed }) => (condensed ? `${40 / 16}rem` : `${32 / 16}rem`)};
  }
`;
const NavLinkWrapper = styled__default.default(reactRouterDom.NavLink) `
  text-decoration: unset;
  color: inherit;
`;
const NavBrand = ({ workplace, title, icon, to = '/' }) => {
    const condensed = MainNavContext.useMainNav();
    if (condensed) {
        return (jsxRuntime.jsx(Box.Box, { paddingLeft: 3, paddingRight: 3, paddingTop: 4, paddingBottom: 4, children: jsxRuntime.jsx(BrandIconWrapper, { condensed: true, children: jsxRuntime.jsxs(reactRouterDom.NavLink, { to: to, children: [icon, jsxRuntime.jsxs(VisuallyHidden.VisuallyHidden, { children: [jsxRuntime.jsx("span", { children: title }), jsxRuntime.jsx("span", { children: workplace })] })] }) }) }));
    }
    return (jsxRuntime.jsx(Box.Box, { paddingLeft: 3, paddingRight: 3, paddingTop: 4, paddingBottom: 4, children: jsxRuntime.jsxs(Flex.Flex, { children: [jsxRuntime.jsx(BrandIconWrapper, { as: reactRouterDom.NavLink, to: to, "aria-hidden": true, tabIndex: -1, children: icon }), jsxRuntime.jsxs(Box.Box, { paddingLeft: 2, children: [jsxRuntime.jsx(Typography.Typography, { fontWeight: "bold", textColor: "neutral800", as: "span", children: jsxRuntime.jsxs(NavLinkWrapper, { to: to, children: [title, jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { as: "span", children: workplace })] }) }), jsxRuntime.jsx(Typography.Typography, { variant: "pi", as: "p", textColor: "neutral600", "aria-hidden": true, children: workplace })] })] }) }));
};

exports.NavBrand = NavBrand;
