'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const reactRouterDom = require('react-router-dom');
const styled = require('styled-components');
const utils = require('../themes/utils.js');
const Typography = require('../Typography/Typography.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const LinkWrapper = styled__default.default.a `
  display: inline-flex;
  align-items: center;
  text-decoration: none;
  pointer-events: ${({ disabled }) => (disabled ? 'none' : undefined)};
  color: ${({ disabled, theme }) => (disabled ? theme.colors.neutral600 : theme.colors.primary600)};

  svg path {
    transition: fill 150ms ease-out;
    fill: currentColor;
  }

  svg {
    font-size: ${10 / 16}rem;
  }

  ${Typography.Typography} {
    transition: color 150ms ease-out;
    color: currentColor;
  }

  &:hover {
    color: ${({ theme }) => theme.colors.primary500};
  }

  &:active {
    color: ${({ theme }) => theme.colors.primary700};
  }

  ${utils.buttonFocusStyle};
`;
const IconWrapper = styled__default.default(Box.Box) `
  display: flex;
`;
const Link = React__namespace.forwardRef(({ children, href, to, disabled = false, startIcon, endIcon, ...restProps }, ref) => {
    const target = href ? '_blank' : undefined;
    const rel = href ? 'noreferrer noopener' : undefined;
    return (jsxRuntime.jsxs(LinkWrapper, { as: to && !disabled ? reactRouterDom.NavLink : 'a', target: target, rel: rel, to: disabled ? undefined : to, href: disabled ? '#' : href, disabled: disabled, ref: ref, ...restProps, children: [startIcon && (jsxRuntime.jsx(IconWrapper, { as: "span", "aria-hidden": true, paddingRight: 2, children: startIcon })), jsxRuntime.jsx(Typography.Typography, { children: children }), endIcon && !href && (jsxRuntime.jsx(IconWrapper, { as: "span", "aria-hidden": true, paddingLeft: 2, children: endIcon })), href && (jsxRuntime.jsx(IconWrapper, { as: "span", "aria-hidden": true, paddingLeft: 2, children: jsxRuntime.jsx(icons.ExternalLink, {}) }))] }));
});

exports.Link = Link;
