'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const keyboardKeys = require('../helpers/keyboardKeys.js');
const Box = require('../Box/Box.js');

const KeyboardNavigable = ({ tagName, attributeName = '', ...props }) => {
    const isValidFocusedElement = () => {
        const focused = document.activeElement;
        if (!focused) {
            return false;
        }
        if (tagName) {
            return focused.tagName.toLowerCase() === tagName;
        }
        return focused.hasAttribute(attributeName);
    };
    const queryElement = (parentEl) => {
        if (tagName) {
            return parentEl.querySelectorAll(tagName);
        }
        return parentEl.querySelectorAll(`[${attributeName}]`);
    };
    const handleKeyDown = (e) => {
        switch (e.key) {
            case keyboardKeys.KeyboardKeys.RIGHT:
            case keyboardKeys.KeyboardKeys.DOWN: {
                if (isValidFocusedElement()) {
                    e.preventDefault();
                    const focused = document.activeElement;
                    const allElements = [...queryElement(e.currentTarget)];
                    const focusedIndex = allElements.findIndex((node) => node === focused);
                    const nextIndex = focusedIndex + 1 < allElements.length ? focusedIndex + 1 : 0;
                    allElements[nextIndex].focus();
                }
                break;
            }
            case keyboardKeys.KeyboardKeys.LEFT:
            case keyboardKeys.KeyboardKeys.UP: {
                if (isValidFocusedElement()) {
                    e.preventDefault();
                    const focused = document.activeElement;
                    const allElements = [...queryElement(e.currentTarget)];
                    const focusedIndex = allElements.findIndex((node) => node === focused);
                    const nextIndex = focusedIndex - 1 > -1 ? focusedIndex - 1 : allElements.length - 1;
                    allElements[nextIndex].focus();
                }
                break;
            }
            case keyboardKeys.KeyboardKeys.HOME: {
                if (isValidFocusedElement()) {
                    e.preventDefault();
                    const allElements = queryElement(e.currentTarget);
                    const focusElement = allElements.item(0);
                    focusElement.focus();
                }
                break;
            }
            case keyboardKeys.KeyboardKeys.END: {
                if (isValidFocusedElement()) {
                    e.preventDefault();
                    const allElements = queryElement(e.currentTarget);
                    const focusElement = allElements.item(allElements.length - 1);
                    focusElement.focus();
                }
                break;
            }
        }
    };
    return jsxRuntime.jsx(Box.Box, { onKeyDown: handleKeyDown, ...props });
};

exports.KeyboardNavigable = KeyboardNavigable;
