'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');
const Tooltip = require('../Tooltip/Tooltip.js');
const BaseButton = require('../BaseButton/BaseButton.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

// TODO: we should align the default state in v2 with the Button
// component
const VARIANT_DEFAULT = 'tertiary';
const VARIANT_SECONDARY = 'secondary';
const SIZES = ['S', 'M', 'L'];
const VARIANTS = [VARIANT_DEFAULT, VARIANT_SECONDARY];
const IconButton = React__namespace.forwardRef(({ label, background, borderWidth, noBorder = false, children, icon, disabled = false, onClick, size = SIZES[0], 'aria-label': ariaLabel, variant = VARIANTS[0], ...restProps }, ref) => {
    const handleClick = (e) => {
        if (!disabled && onClick) {
            onClick(e);
        }
    };
    const component = (jsxRuntime.jsxs(IconButtonWrapper, { "aria-disabled": disabled, background: disabled ? 'neutral150' : background, borderWidth: noBorder ? 0 : borderWidth, justifyContent: "center", ...restProps, ref: ref, size: size, onClick: handleClick, variant: variant, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { as: "span", children: label ?? ariaLabel }), React__namespace.cloneElement((icon || children), {
                'aria-hidden': true,
                focusable: false, // See: https://allyjs.io/tutorials/focusing-in-svg.html#making-svg-elements-focusable
            })] }));
    return label ? jsxRuntime.jsx(Tooltip.Tooltip, { label: label, children: component }) : component;
});
const IconButtonWrapper = styled__default.default(BaseButton.BaseButton) `
  background-color: ${({ theme, variant }) => {
    if (variant === VARIANT_SECONDARY) {
        return theme.colors.primary100;
    }
    return undefined;
}};
  border-color: ${({ theme, variant }) => {
    if (variant === VARIANT_SECONDARY) {
        return theme.colors.primary200;
    }
    return theme.colors.neutral200;
}};
  height: ${({ theme, size }) => theme.sizes.button[size]};
  width: ${({ theme, size }) => theme.sizes.button[size]};

  svg {
    g,
    path {
      fill: ${({ theme, variant }) => {
    if (variant === VARIANT_SECONDARY) {
        return theme.colors.primary500;
    }
    return theme.colors.neutral500;
}};
    }
  }

  :hover,
  :focus {
    svg {
      g,
      path {
        fill: ${({ theme, variant }) => {
    if (variant === VARIANT_SECONDARY) {
        return theme.colors.primary600;
    }
    return theme.colors.neutral600;
}};
      }
    }
  }

  &[aria-disabled='true'] {
    svg {
      path {
        fill: ${({ theme }) => theme.colors.neutral600};
      }
    }
  }
`;
const IconButtonGroup = styled__default.default(Flex.Flex) `
  & span:first-child button {
    border-left: 1px solid ${({ theme }) => theme.colors.neutral200};
    border-radius: ${({ theme }) => `${theme.borderRadius} 0 0 ${theme.borderRadius}`};
  }

  & span:last-child button {
    border-radius: ${({ theme }) => `0 ${theme.borderRadius} ${theme.borderRadius} 0`};
  }

  & ${IconButtonWrapper} {
    border-radius: 0;
    border-left: none;

    svg {
      path {
        fill: ${({ theme }) => theme.colors.neutral700};
      }
    }

    &:hover {
      background-color: ${({ theme }) => theme.colors.neutral100};

      svg {
        path {
          fill: ${({ theme }) => theme.colors.neutral800};
        }
      }
    }

    &:active {
      background-color: ${({ theme }) => theme.colors.neutral150};
      svg {
        path {
          fill: ${({ theme }) => theme.colors.neutral900};
        }
      }
    }

    &[aria-disabled='true'] {
      svg {
        path {
          fill: ${({ theme }) => theme.colors.neutral600};
        }
      }
    }
  }
`;

exports.IconButton = IconButton;
exports.IconButtonGroup = IconButtonGroup;
