import { jsx } from 'react/jsx-runtime';
import React__default from 'react';
import styled from 'styled-components';
import { extractStyleFromTheme } from '../helpers/theme.mjs';
import { Box } from '../Box/Box.mjs';

const IconWrapper = styled(Box) `
  path {
    fill: ${({ color, theme }) => extractStyleFromTheme(theme.colors, color, undefined)};
  }
  ${({ theme, colors }) => colors(theme)}
`;
const Icon = React__default.forwardRef(({ color = 'neutral600', colors = () => '', ...restProps }, ref) => {
    return jsx(IconWrapper, { ref: ref, color: color, colors: colors, ...restProps });
});
Icon.displayName = 'Icon';

export { Icon };
