'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const theme = require('../helpers/theme.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const IconWrapper = styled__default.default(Box.Box) `
  path {
    fill: ${({ color, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.colors, color, undefined)};
  }
  ${({ theme, colors }) => colors(theme)}
`;
const Icon = React__default.default.forwardRef(({ color = 'neutral600', colors = () => '', ...restProps }, ref) => {
    return jsxRuntime.jsx(IconWrapper, { ref: ref, color: color, colors: colors, ...restProps });
});
Icon.displayName = 'Icon';

exports.Icon = Icon;
