import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import handleResponsiveValues from '../helpers/handleResponsiveValues.mjs';
import { Box } from '../Box/Box.mjs';

const GridWrapper = styled(Box) `
  display: grid;
  grid-template-columns: repeat(${({ gridCols }) => gridCols}, 1fr);
  ${({ theme, gap }) => handleResponsiveValues('gap', gap, theme)}
`;
const Grid = (props) => {
    const { gap = '0', gridCols = 12, ...rest } = props;
    return jsx(GridWrapper, { gap: gap, gridCols: gridCols, ...rest });
};

export { Grid };
