import styled from 'styled-components';
import handleResponsiveValues from '../helpers/handleResponsiveValues.mjs';
import { Box } from '../Box/Box.mjs';

/**
 * Prevents these attributes from being spread on the DOM node
 */
const transientProps = {
    direction: true,
};
const Flex = styled(Box).withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  align-items: ${({ alignItems = 'center' }) => alignItems};
  display: ${({ display = 'flex', inline }) => (inline ? 'inline-flex' : display)};
  flex-direction: ${({ direction = 'row' }) => direction};
  flex-shrink: ${({ shrink }) => shrink};
  flex-wrap: ${({ wrap }) => wrap};
  ${({ gap, theme }) => handleResponsiveValues('gap', gap, theme)};
  justify-content: ${({ justifyContent }) => justifyContent};
`;

export { Flex };
