'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const FieldContext = require('./FieldContext.js');
const deprecations = require('../helpers/deprecations.js');
const Typography = require('../Typography/Typography.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const warnOnce = deprecations.once(console.warn);
const FieldLabel = React.forwardRef(({ children, action, required: requiredDeprecatedProp, ...props }, ref) => {
    const { id, required: requiredField } = FieldContext.useField();
    const required = requiredField || requiredDeprecatedProp;
    if (requiredDeprecatedProp !== undefined) {
        warnOnce('Deprecation warning: Usage of "required" prop in FieldLabel component is deprecated. This is discouraged and will be removed in the next major release. Please use the Field component to share the required prop.');
    }
    return (jsxRuntime.jsxs(TypographyFlex, { ref: ref, variant: "pi", textColor: "neutral800", htmlFor: id, fontWeight: "bold", as: "label", ...props, children: [children, required && jsxRuntime.jsx(TypographyAsterisk, { textColor: "danger600", children: "*" }), action && jsxRuntime.jsx(Action, { marginLeft: 1, children: action })] }));
});
/**
 * NOTE!
 * This is a concious decision to not use the Box component here.
 * Partially because it must be a span to correctly be picked up,
 * but also because we don't need to add DOM nesting here when it's
 * easier to just add a new class.
 */
const TypographyFlex = styled__default.default(Typography.Typography) `
  display: flex;
  align-items: center;
`;
const TypographyAsterisk = styled__default.default(Typography.Typography) `
  line-height: 0;
`;
const Action = styled__default.default(Flex.Flex) `
  line-height: 0;

  svg path {
    fill: ${({ theme }) => theme.colors.neutral500};
  }
`;

exports.FieldLabel = FieldLabel;
