import { jsx } from 'react/jsx-runtime';
import { useField } from './FieldContext.mjs';
import { Typography } from '../Typography/Typography.mjs';

const FieldHint = () => {
    const { id, hint, error } = useField();
    if (!hint || error) {
        return null;
    }
    return (jsx(Typography, { variant: "pi", as: "p", id: `${id}-hint`, textColor: "neutral600", children: hint }));
};

export { FieldHint };
