import { jsx } from 'react/jsx-runtime';
import { forwardRef, useMemo } from 'react';
import { FieldContext } from './FieldContext.mjs';
import { useId } from '../hooks/useId.mjs';
import { Box } from '../Box/Box.mjs';

const Field = forwardRef(({ children, name, error, hint, id, required = false, ...props }, ref) => {
    const generatedId = useId(id);
    const context = useMemo(() => ({ name, id: generatedId, error, hint, required }), [error, generatedId, hint, name, required]);
    return (jsx(Box, { ref: ref, ...props, children: jsx(FieldContext.Provider, { value: context, children: children }) }));
});

export { Field };
