import { jsxs, jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const EmptyStateIconWrapper = styled(Box) `
  svg {
    height: ${88 / 16}rem;
  }
`;
const EmptyStateLayout = ({ icon, content, action, hasRadius = true, shadow = 'tableShadow', }) => {
    return (jsxs(Flex, { alignItems: "center", direction: "column", padding: 11, background: "neutral0", hasRadius: hasRadius, shadow: shadow, children: [jsx(EmptyStateIconWrapper, { paddingBottom: 6, "aria-hidden": true, children: icon }), jsx(Box, { paddingBottom: 4, children: jsx(Typography, { variant: "delta", as: "p", textAlign: "center", textColor: "neutral600", children: content }) }), action] }));
};

export { EmptyStateLayout };
