'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const EmptyStateIconWrapper = styled__default.default(Box.Box) `
  svg {
    height: ${88 / 16}rem;
  }
`;
const EmptyStateLayout = ({ icon, content, action, hasRadius = true, shadow = 'tableShadow', }) => {
    return (jsxRuntime.jsxs(Flex.Flex, { alignItems: "center", direction: "column", padding: 11, background: "neutral0", hasRadius: hasRadius, shadow: shadow, children: [jsxRuntime.jsx(EmptyStateIconWrapper, { paddingBottom: 6, "aria-hidden": true, children: icon }), jsxRuntime.jsx(Box.Box, { paddingBottom: 4, children: jsxRuntime.jsx(Typography.Typography, { variant: "delta", as: "p", textAlign: "center", textColor: "neutral600", children: content }) }), action] }));
};

exports.EmptyStateLayout = EmptyStateLayout;
