import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';

const DividerWrapper = styled(Box) `
  height: 1px;
  border: none;
  /* If contained in a Flex parent we want to prevent the Divider to shink */
  flex-shrink: 0;
  ${({ unsetMargin }) => (unsetMargin ? 'margin: 0;' : '')}
`;
const Divider = ({ unsetMargin = true, ...props }) => {
    return jsx(DividerWrapper, { ...props, background: "neutral150", as: "hr", unsetMargin: unsetMargin });
};

export { Divider };
