'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const index = require('../DismissibleLayer/index.js');
const setOpacity = require('../helpers/setOpacity.js');
const useId = require('../hooks/useId.js');
const useLockScroll = require('../hooks/useLockScroll.js');
const FocusTrap = require('../FocusTrap/FocusTrap.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');
const Portal = require('../Portal/Portal.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const DialogWrapper = styled__default.default(Box.Box) `
  inset: 0;
  background: ${({ theme }) => setOpacity.setOpacity(theme.colors.neutral800, 0.2)};
`;
const DialogContainer = styled__default.default(Box.Box) `
  max-width: ${412 / 16}rem;
  margin: 0 auto;
  overflow: hidden;
  margin-top: 10%;
`;
const DialogHeader = styled__default.default(Flex.Flex) `
  border-bottom: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const Dialog = ({ onClose, title, as = 'h2', isOpen, id, ...props }) => {
    const generatedId = useId.useId(id);
    useLockScroll(isOpen);
    if (!isOpen) {
        return null;
    }
    const labelledBy = `${generatedId}-label`;
    return (jsxRuntime.jsx(Portal.Portal, { children: jsxRuntime.jsx(DialogWrapper, { padding: 8, position: "fixed", zIndex: 4, children: jsxRuntime.jsx(FocusTrap.FocusTrap, { children: jsxRuntime.jsx(index.DismissibleLayer, { onEscapeKeyDown: onClose, onPointerDownOutside: onClose, children: jsxRuntime.jsxs(DialogContainer, { "aria-labelledby": labelledBy, "aria-modal": true, background: "neutral0", hasRadius: true, shadow: "popupShadow", role: "dialog", children: [jsxRuntime.jsx(DialogHeader, { padding: 6, justifyContent: "center", children: jsxRuntime.jsx(Typography.Typography, { variant: "beta", as: as, id: labelledBy, children: title }) }), jsxRuntime.jsx(Box.Box, { ...props })] }) }) }) }) }));
};

exports.Dialog = Dialog;
