import { jsx } from 'react/jsx-runtime';
import { createContext } from './helpers/context.mjs';
import { ThemeProvider } from './ThemeProvider/ThemeProvider.mjs';

const DEFAULT_LOCALE = 'en-EN';
const getDefaultLocale = () => {
    if (typeof navigator === 'undefined') {
        return DEFAULT_LOCALE;
    }
    if (navigator.language) {
        return navigator.language;
    }
    return DEFAULT_LOCALE;
};
const [Provider, useDesignSystem] = createContext('StrapiDesignSystem', {
    locale: getDefaultLocale(),
});
const DesignSystemProvider = ({ locale = getDefaultLocale(), ...restProps }) => {
    return (jsx(Provider, { locale: locale, children: jsx(ThemeProvider, { ...restProps }) }));
};

export { DesignSystemProvider, useDesignSystem };
