'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const useId = require('../hooks/useId.js');
const FieldContext = require('../Field/FieldContext.js');
const Typography = require('../Typography/Typography.js');
const BaseCheckbox = require('../BaseCheckbox/BaseCheckbox.js');
const Field = require('../Field/Field.js');
const Flex = require('../Flex/Flex.js');
const Box = require('../Box/Box.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const CheckboxLabel = styled__default.default(Typography.Typography) `
  display: flex;
  align-items: flex-start;
  * {
    cursor: ${({ disabled }) => (disabled ? 'not-allowed' : 'pointer')};
  }
`;
const CheckboxTick = React__namespace.forwardRef((props, forwardedRef) => {
    const { id } = FieldContext.useField();
    return jsxRuntime.jsx(BaseCheckbox.BaseCheckbox, { ref: forwardedRef, id: id, ...props });
});
const Checkbox = React__namespace.forwardRef(({ children, disabled = false, id, hint, error, ...props }, forwardedRef) => {
    const generatedId = useId.useId(id);
    let ariaDescription;
    if (error) {
        ariaDescription = `${generatedId}-error`;
    }
    else if (hint) {
        ariaDescription = `${generatedId}-hint`;
    }
    return (jsxRuntime.jsx(Field.Field, { id: generatedId, hint: hint, error: error, children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [jsxRuntime.jsxs(CheckboxLabel, { as: "label", textColor: "neutral800", disabled: disabled, children: [jsxRuntime.jsx(CheckboxTick, { ref: forwardedRef, disabled: disabled, "aria-describedby": ariaDescription, ...props }), jsxRuntime.jsx(Box.Box, { paddingLeft: 2, children: children })] }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});

exports.Checkbox = Checkbox;
