import { jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import styled from 'styled-components';
import { ellipsisStyle } from '../Typography/utils.mjs';
import { Box } from '../Box/Box.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';

const StyledImage = styled(Box) `
  ${ellipsisStyle({ ellipsis: true })}
`;
const CarouselImage = (props) => {
    const [isError, setIsError] = useState(false);
    const handleImageError = () => {
        setIsError(true);
    };
    if (isError) {
        return (jsx(Tooltip, { description: props.alt ?? '', children: jsx(StyledImage, { as: "img", height: "100%", maxWidth: "100%", ...props }) }));
    }
    return jsx(StyledImage, { as: "img", height: "100%", maxWidth: "100%", ...props, onError: handleImageError });
};

export { CarouselImage };
